/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_8685;
import org.tlauncher.TLSkinCape;
import org.tlauncher.minecraft.Resource;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.ProfileTexture;
import org.tlauncher.renderer.TextureManager;

public class PlayerSkinManager {
    private final TLSkinCape tlSkinCape;
    private final TextureManager textureManager;
    private final Map<PlayerName, List<class_8685>> playerSkins = new ConcurrentHashMap<PlayerName, List<class_8685>>();
    private final List<class_8685> emptySkins = Collections.unmodifiableList(new ArrayList());

    public class_8685 getPlayerSkin(GameProfile gameProfile, PlayerName playerName) {
        ProfileTexture profileTexture;
        boolean isSkinInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.SKIN);
        boolean isCapeInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.CAPE);
        List<class_8685> result = this.playerSkins.get(playerName);
        if (result == null) {
            if (!isSkinInit || !isCapeInit) {
                this.tlSkinCape.createTexture(gameProfile, playerName);
                return null;
            }
            profileTexture = this.textureManager.get(playerName);
            if (profileTexture == null) {
                return null;
            }
            List<class_8685> skins = this.extractPlayerSkins(profileTexture);
            result = skins;
            this.playerSkins.put(playerName, result);
        } else {
            profileTexture = this.textureManager.get(playerName);
        }
        if (profileTexture != null && profileTexture.getCape() != null) {
            if (profileTexture.getCape().getFrames().size() == 1) {
                return result.get(0);
            }
            profileTexture.getCape().getFrame();
            return result.get(profileTexture.getCape().getCurrentFrameIndex());
        }
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    private List<class_8685> extractPlayerSkins(ProfileTexture profileTexture) {
        if (profileTexture.getSkin() == null) {
            return this.emptySkins;
        }
        class_8685.class_7920 model = "slim".equals(profileTexture.getSkinType()) ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123;
        ArrayList<class_8685> skins = new ArrayList<class_8685>();
        boolean secure = false;
        if (profileTexture.getCape() != null) {
            for (Resource frame : profileTexture.getCape().getFrames()) {
                skins.add(new class_8685((class_2960)profileTexture.getSkin(), null, (class_2960)frame, (class_2960)(profileTexture.isHasElytra() ? frame : null), model, secure));
            }
        } else {
            skins.add(new class_8685((class_2960)profileTexture.getSkin(), null, null, null, model, secure));
        }
        return skins;
    }

    public PlayerSkinManager(TLSkinCape tlSkinCape, TextureManager textureManager) {
        this.tlSkinCape = tlSkinCape;
        this.textureManager = textureManager;
    }
}

