/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tweaker;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_437;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.lang3.ArrayUtils;
import org.tlauncher.Logger;

public class Tweaker
implements ITweaker {
    private String[] args;
    public static String serverName;
    public static int serverPort;
    public static boolean isTLSkinCapeEnabled;
    public static boolean useOldWearing;
    public static boolean isConnectorEnabled;
    public static boolean isOptiFineVersion;
    public static boolean isConnectorStarted;
    public static Logger logger;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        File tweakerLogFile = new File(gameDir, "./tlLoader/Tweaker.log");
        logger = new Logger(tweakerLogFile);
        logger.info("Using Tweaker");
        logger.info("Tweaker: acceptOptions");
        ArrayList<String> argsTemp = new ArrayList<String>(args);
        Iterator iterator = argsTemp.iterator();
        while (iterator.hasNext()) {
            String arg;
            switch (arg = (String)iterator.next()) {
                case "--server": {
                    iterator.remove();
                    serverName = (String)iterator.next();
                    iterator.remove();
                    break;
                }
                case "--port": {
                    iterator.remove();
                    serverPort = Integer.parseInt((String)iterator.next());
                    iterator.remove();
                    break;
                }
                case "--disable_tl_skin_cape": {
                    iterator.remove();
                    isTLSkinCapeEnabled = false;
                    logger.info("TLSkinCape disabled.");
                    break;
                }
                case "--tl_old_wearing": {
                    iterator.remove();
                    useOldWearing = true;
                    logger.info("TLSkinCape uses the old wearing hook.");
                    break;
                }
                case "--tl_disable_connector": {
                    iterator.remove();
                    isConnectorEnabled = false;
                }
            }
        }
        if (serverPort == 0) {
            serverPort = 25565;
        }
        if (serverName != null) {
            logger.info("[Connector] Found connection params: %s:%s.", serverName, serverPort);
        }
        Object[] temp = new String[]{"--gameDir", gameDir.getAbsolutePath(), "--assetsDir", assetsDir.getAbsolutePath(), "--version", profile};
        Object[] args0 = argsTemp.toArray(new String[0]);
        this.args = isOptiFineVersion ? new String[0] : (String[])ArrayUtils.addAll((Object[])args0, (Object[])temp);
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        logger.info("Tweaker: injectIntoClassLoader");
        classLoader.registerTransformer("org.tlauncher.tweaker.hook.HookClassTransformer");
        classLoader.registerTransformer("org.tlauncher.injection.InjectionClassTransformer");
        logger.info("Loaded as a library.");
        try {
            Class.forName(class_437.class.getName(), true, (ClassLoader)Launch.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLaunchTarget() {
        logger.info("Tweaker: getLaunchTarget");
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        logger.info("Tweaker: getLaunchArguments");
        return this.args;
    }

    static {
        isTLSkinCapeEnabled = true;
        isConnectorEnabled = true;
        logger = new Logger();
        try {
            Class.forName("optifine.OptiFineTweaker");
            isOptiFineVersion = true;
            logger.info("Tweaker: OptiFine detected.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

