/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import java.nio.ByteBuffer;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.BufferBuilderPolygonView;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.ExtendingBufferBuilder;
import net.coderbot.iris.vertices.IrisExtendedBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4584;
import net.minecraft.class_4585;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_287.class})
public abstract class MixinBufferBuilder
extends class_4585
implements class_4584,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder,
IrisExtendedBufferBuilder {
    @Unique
    private boolean iris$shouldNotExtend;
    @Unique
    private boolean extending;
    @Unique
    private boolean iris$isTerrain;
    @Unique
    private boolean injectNormalAndUV1;
    @Unique
    private int vertexCount;
    @Unique
    private short currentBlock = (short)-1;
    @Unique
    private short currentRenderType = (short)-1;
    @Unique
    private int currentLocalPosX;
    @Unique
    private int currentLocalPosY;
    @Unique
    private int currentLocalPosZ;
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Shadow
    private ByteBuffer field_1555;
    @Shadow
    private class_293.class_5596 field_1567;
    @Shadow
    private class_293 field_1565;
    @Shadow
    private int field_20884;
    @Shadow
    @Nullable
    private class_296 field_1558;

    @Shadow
    public abstract void method_1328(class_293.class_5596 var1, class_293 var2);

    @Shadow
    public abstract void method_22898(int var1, short var2);

    @Shadow
    public abstract void method_1325();

    @Override
    public void iris$beginWithoutExtending(class_293.class_5596 class_55962, class_293 class_2932) {
        this.iris$shouldNotExtend = true;
        this.method_1328(class_55962, class_2932);
        this.iris$shouldNotExtend = false;
    }

    @NotNull
    public class_4588 method_22921(int n, int n2) {
        return super.method_22921(n, n2);
    }

    @ModifyVariable(method={"begin"}, at=@At(value="HEAD"), argsOnly=true)
    private class_293 iris$extendFormat(class_293 class_2932) {
        this.extending = false;
        this.iris$isTerrain = false;
        this.injectNormalAndUV1 = false;
        if (this.iris$shouldNotExtend || !BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat()) {
            return class_2932;
        }
        if (class_2932 == class_290.field_1590) {
            this.extending = true;
            this.iris$isTerrain = true;
            this.injectNormalAndUV1 = false;
            return IrisVertexFormats.TERRAIN;
        }
        if (class_2932 == class_290.field_1580) {
            this.extending = true;
            this.iris$isTerrain = false;
            this.injectNormalAndUV1 = false;
            return IrisVertexFormats.ENTITY;
        }
        if (class_2932 == class_290.field_20888) {
            this.extending = true;
            this.iris$isTerrain = false;
            this.injectNormalAndUV1 = true;
            return IrisVertexFormats.GLYPH;
        }
        return class_2932;
    }

    @Inject(method={"reset()V"}, at={@At(value="HEAD")})
    private void iris$onReset(CallbackInfo callbackInfo) {
        this.vertexCount = 0;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo callbackInfo) {
        if (!this.extending) {
            return;
        }
        if (this.injectNormalAndUV1 && this.field_1558 == class_290.field_1579) {
            this.putInt(0, 0);
            this.method_1325();
        }
        if (this.iris$isTerrain) {
            this.method_22898(0, this.currentBlock);
            this.method_22898(2, this.currentRenderType);
        } else {
            this.method_22898(0, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity());
            this.method_22898(2, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity());
            this.method_22898(4, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem());
        }
        this.method_1325();
        this.method_22897(0, 0.0f);
        this.method_22897(4, 0.0f);
        this.method_1325();
        this.putInt(0, 0);
        this.method_1325();
        if (this.iris$isTerrain) {
            int n = this.field_20884 - 48;
            float f = this.field_1555.getFloat(n);
            float f2 = this.field_1555.getFloat(n + 4);
            float f3 = this.field_1555.getFloat(n + 8);
            this.putInt(0, ExtendedDataHelper.computeMidBlock(f, f2, f3, this.currentLocalPosX, this.currentLocalPosY, this.currentLocalPosZ));
            this.method_1325();
        }
        ++this.vertexCount;
        if (this.field_1567 == class_293.class_5596.field_27382 && this.vertexCount == 4 || this.field_1567 == class_293.class_5596.field_27379 && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Unique
    private void fillExtendedData(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.vertexCount = 0;
        int n6 = this.field_1565.method_1362();
        this.polygon.setup(this.field_1555, this.field_20884, n6, n);
        float f = 0.0f;
        float f2 = 0.0f;
        for (n5 = 0; n5 < n; ++n5) {
            f += this.polygon.u(n5);
            f2 += this.polygon.v(n5);
        }
        f /= (float)n;
        f2 /= (float)n;
        if (this.iris$isTerrain) {
            n5 = 16;
            n4 = 12;
            n3 = 24;
            n2 = 8;
        } else {
            n5 = 14;
            n4 = 10;
            n3 = 24;
            n2 = 6;
        }
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                int n7 = this.field_1555.getInt(this.field_20884 - n3 - n6 * i);
                int n8 = NormalHelper.computeTangentSmooth(NormI8.unpackX(n7), NormI8.unpackY(n7), NormI8.unpackZ(n7), this.polygon);
                this.field_1555.putFloat(this.field_20884 - n5 - n6 * i, f);
                this.field_1555.putFloat(this.field_20884 - n4 - n6 * i, f2);
                this.field_1555.putInt(this.field_20884 - n2 - n6 * i, n8);
            }
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
            int n9 = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            int n10 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
            for (int i = 0; i < n; ++i) {
                this.field_1555.putFloat(this.field_20884 - n5 - n6 * i, f);
                this.field_1555.putFloat(this.field_20884 - n4 - n6 * i, f2);
                this.field_1555.putInt(this.field_20884 - n3 - n6 * i, n9);
                this.field_1555.putInt(this.field_20884 - n2 - n6 * i, n10);
            }
        }
    }

    @Unique
    private void putInt(int n, int n2) {
        this.field_1555.putInt(this.field_20884 + n, n2);
    }

    @Override
    public void beginBlock(short s, short s2, int n, int n2, int n3) {
        this.currentBlock = s;
        this.currentRenderType = s2;
        this.currentLocalPosX = n;
        this.currentLocalPosY = n2;
        this.currentLocalPosZ = n3;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }

    @Override
    public class_293 iris$format() {
        return this.field_1565;
    }

    @Override
    public class_293.class_5596 iris$mode() {
        return this.field_1567;
    }

    @Override
    public boolean iris$extending() {
        return this.extending;
    }

    @Override
    public boolean iris$isTerrain() {
        return this.iris$isTerrain;
    }

    @Override
    public boolean iris$injectNormalAndUV1() {
        return this.injectNormalAndUV1;
    }

    @Override
    public int iris$vertexCount() {
        return this.vertexCount;
    }

    @Override
    public void iris$incrementVertexCount() {
        ++this.vertexCount;
    }

    @Override
    public void iris$resetVertexCount() {
        this.vertexCount = 0;
    }

    @Override
    public short iris$currentBlock() {
        return this.currentBlock;
    }

    @Override
    public short iris$currentRenderType() {
        return this.currentRenderType;
    }

    @Override
    public int iris$currentLocalPosX() {
        return this.currentLocalPosX;
    }

    @Override
    public int iris$currentLocalPosY() {
        return this.currentLocalPosY;
    }

    @Override
    public int iris$currentLocalPosZ() {
        return this.currentLocalPosZ;
    }
}

