/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.class_1044;

public class IrisSamplers {
    public static final int ALBEDO_TEXTURE_UNIT = 0;
    public static final int OVERLAY_TEXTURE_UNIT = 1;
    public static final int LIGHTMAP_TEXTURE_UNIT = 2;
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)1, (Object)2);
    private static GlSampler SHADOW_SAMPLER_NEAREST;
    private static GlSampler SHADOW_SAMPLER_LINEAR;
    private static GlSampler LINEAR_MIPMAP;
    private static GlSampler NEAREST_MIPMAP;

    private IrisSamplers() {
    }

    public static void initRenderer() {
        SHADOW_SAMPLER_NEAREST = new GlSampler(false, false, true, true);
        SHADOW_SAMPLER_LINEAR = new GlSampler(true, false, true, true);
        LINEAR_MIPMAP = new GlSampler(true, true, false, false);
        NEAREST_MIPMAP = new GlSampler(false, true, false, false);
    }

    public static void addRenderTargetSamplers(SamplerHolder samplerHolder, Supplier<ImmutableSet<Integer>> supplier, RenderTargets renderTargets, boolean bl) {
        int n;
        for (int i = n = bl ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int n2 = i;
            IntSupplier intSupplier = () -> {
                ImmutableSet immutableSet = (ImmutableSet)supplier.get();
                RenderTarget renderTarget = renderTargets.getOrCreate(n2);
                if (immutableSet.contains((Object)n2)) {
                    return renderTarget.getAltTexture();
                }
                return renderTarget.getMainTexture();
            };
            String string = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String string2 = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (samplerHolder.hasSampler(string2) || samplerHolder.hasSampler(string)) {
                    renderTargets.createIfUnsure(n2);
                }
                if (i == 0 && bl) {
                    samplerHolder.addDefaultSampler(TextureType.TEXTURE_2D, intSupplier, null, null, string, string2);
                    continue;
                }
                samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, intSupplier, null, string, string2);
                continue;
            }
            if (samplerHolder.hasSampler(string)) {
                renderTargets.createIfUnsure(n2);
            }
            samplerHolder.addDynamicSampler(intSupplier, string);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplerHolder, TextureAccess textureAccess) {
        samplerHolder.addDynamicSampler(textureAccess.getTextureId(), "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplerHolder) {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object[])new String[]{"shadowtex0", "shadowtex0HW", "shadowtex1", "shadowtex1HW", "shadow", "watershadow", "shadowcolor"});
        for (int i = 0; i < 8; ++i) {
            builder.add((Object)("shadowcolor" + i));
            builder.add((Object)("shadowcolorimg" + i));
        }
        for (String string : builder.build()) {
            if (!samplerHolder.hasSampler(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplerHolder, ShadowRenderTargets shadowRenderTargets, ImmutableSet<Integer> immutableSet, boolean bl) {
        boolean bl2;
        boolean bl3 = samplerHolder.hasSampler("watershadow");
        if (bl3) {
            bl2 = true;
            samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, bl ? null : (shadowRenderTargets.isHardwareFiltered(0) ? (shadowRenderTargets.isLinearFiltered(0) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : null), "shadowtex0", "watershadow");
            samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, bl ? null : (shadowRenderTargets.isHardwareFiltered(1) ? (shadowRenderTargets.isLinearFiltered(1) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : null), "shadowtex1", "shadow");
        } else {
            bl2 = samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, bl ? null : (shadowRenderTargets.isHardwareFiltered(0) ? (shadowRenderTargets.isLinearFiltered(0) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : null), "shadowtex0", "shadow");
            bl2 |= samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, bl ? null : (shadowRenderTargets.isHardwareFiltered(1) ? (shadowRenderTargets.isLinearFiltered(1) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : null), "shadowtex1");
        }
        if (immutableSet == null) {
            if (samplerHolder.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(0), "shadowcolor")) {
                shadowRenderTargets.createIfEmpty(0);
            }
            for (int i = 0; i < shadowRenderTargets.getRenderTargetCount(); ++i) {
                int n = i;
                if (!samplerHolder.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(n), "shadowcolor" + i)) continue;
                shadowRenderTargets.createIfEmpty(n);
            }
        } else {
            if (samplerHolder.addDynamicSampler(() -> immutableSet.contains((Object)0) ? shadowRenderTargets.get(0).getAltTexture() : shadowRenderTargets.get(0).getMainTexture(), "shadowcolor")) {
                shadowRenderTargets.createIfEmpty(0);
            }
            for (int i = 0; i < shadowRenderTargets.getRenderTargetCount(); ++i) {
                int n = i;
                if (!samplerHolder.addDynamicSampler(() -> immutableSet.contains((Object)n) ? shadowRenderTargets.get(n).getAltTexture() : shadowRenderTargets.get(n).getMainTexture(), "shadowcolor" + i)) continue;
                shadowRenderTargets.createIfEmpty(n);
            }
        }
        if (shadowRenderTargets.isHardwareFiltered(0) && bl) {
            samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, shadowRenderTargets.isLinearFiltered(0) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST, "shadowtex0HW");
        }
        if (shadowRenderTargets.isHardwareFiltered(1) && bl) {
            samplerHolder.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, shadowRenderTargets.isLinearFiltered(1) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST, "shadowtex1HW");
        }
        return bl2;
    }

    public static boolean hasPBRSamplers(SamplerHolder samplerHolder) {
        return samplerHolder.hasSampler("normals") || samplerHolder.hasSampler("specular");
    }

    public static void addLevelSamplers(SamplerHolder samplerHolder, WorldRenderingPipeline worldRenderingPipeline, class_1044 class_10442, InputAvailability inputAvailability) {
        if (inputAvailability.texture) {
            samplerHolder.addExternalSampler(0, "tex", "texture", "gtexture");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10442).method_4624(), "tex", "texture", "gtexture", "gcolor", "colortex0");
        }
        if (inputAvailability.lightmap) {
            samplerHolder.addExternalSampler(2, "lightmap");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10442).method_4624(), "lightmap");
        }
        if (inputAvailability.overlay) {
            samplerHolder.addExternalSampler(1, "iris_overlay");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10442).method_4624(), "iris_overlay");
        }
        samplerHolder.addDynamicSampler(worldRenderingPipeline::getCurrentNormalTexture, StateUpdateNotifiers.normalTextureChangeNotifier, "normals");
        samplerHolder.addDynamicSampler(worldRenderingPipeline::getCurrentSpecularTexture, StateUpdateNotifiers.specularTextureChangeNotifier, "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }

    public static void addCustomTextures(SamplerHolder samplerHolder, Object2ObjectMap<String, TextureAccess> object2ObjectMap) {
        object2ObjectMap.forEach((string, textureAccess) -> samplerHolder.addDynamicSampler(textureAccess.getType(), textureAccess.getTextureId(), null, (String)string));
    }

    public static void addCustomImages(SamplerHolder samplerHolder, Set<GlImage> set) {
        set.forEach(glImage -> {
            if (glImage.getSamplerName() != null) {
                samplerHolder.addDynamicSampler(glImage.getTarget(), glImage::getId, null, glImage.getSamplerName());
            }
        });
    }
}

